<?php

namespace Core\Provider\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Auth\Resources\UserResource;
use Core\Contract\Resources\ContractResource;
use Core\Shipment\Resources\ShipmentResource;
use Core\Shipment\Resources\InterestResource;
use Core\Financial\Resources\RequestResource;
use Core\Common\Resources\CompanyResource;

class ProviderResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $route_name = $request->route()->getName();
        return [
            'id'                => $this->id,
            'name'              => $this->name,
            'type'              => $this->type,
            'is_active'         => $this->is_active,
            'price'             => $this->when(isset($this->price), $this->price),
            'margin'            => $this->when(isset($this->margin), $this->margin),
            'margin_percentage' => $this->when(isset($this->margin_percentage), $this->margin_percentage),
            'is_backhauling'    => $this->when(isset($this->is_backhauling), $this->is_backhauling),
            $this->mergeWhen($route_name == 'api.v1.providers.show', [
                'driver'    => $this->when($this->type == 'freelancer', new DriverResource($this->driver)),
                'drivers'   => $this->when($this->type == 'partner', DriverResource::collection($this->drivers)),
                'shipments' => ShipmentResource::collection($this->shipments),
                'interests' => InterestResource::collection($this->interests),
                'requests'  => RequestResource::collection($this->requests)
            ]),
            $this->mergeWhen($route_name == 'api.v1.shipments.show', [
                'interest' => $this->when($this->interest, new InterestResource($this->interest))
            ]),
            $this->mergeWhen($route_name == 'api.v1.providers.show' || $route_name == 'api.v1.shipments.show', [
                'user' => new UserResource($this->user),
                'company' => new CompanyResource($this->company),
            ]),
            $this->mergeWhen(in_array($route_name, ['api.v1.providers.show', 'api.v1.auth.me', 'api.v1.auth.login']), [
                'contract' => new ContractResource($this->contract)
            ])
        ];
    }
}
