<?php

namespace Core\Provider\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Auth\Resources\UserResource;
use Core\Shipment\Resources\ShipmentResource;

class DriverResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $route_name = $request->route()->getName();
        return [
            'id'                           => $this->provider->type == 'partner' ? $this->id : null,
            'id_copy'                      => $this->id_copy,
            'driving_license_number'       => $this->driving_license_number,
            'driving_license_copy'         => $this->driving_license_copy,
            'sponsor_establishment_name'   => $this->sponsor_establishment_name,
            'sponsor_establishment_number' => $this->sponsor_establishment_number,
            'nationality_id'               => $this->nationality_id,
            'license_id'                   => $this->license_id,
            'expiry_date'                  => $this->expiry_date,
            $this->mergeWhen($route_name == 'api.v1.drivers.show', [
                'trucks'    => $this->when($this->provider->type == 'partner', TruckResource::collection($this->trucks)),
                'provider'  => new ProviderResource($this->provider),
                'shipments' => ShipmentResource::collection($this->shipments)
            ]),
            $this->mergeWhen($route_name == 'api.v1.drivers.index' || $route_name == 'api.v1.drivers.show' || $route_name == 'api.v1.shipments.show' || $route_name == 'api.v1.trucks.index', [
                'user' => new UserResource($this->user)
            ]),
            $this->mergeWhen(($route_name == 'api.v1.drivers.show' || $route_name == 'api.v1.providers.show') && $this->provider->type == 'freelancer', [
                'truck' => new TruckResource($this->truck)
            ]),
        ];
    }
}
