<?php

namespace Core\Provider\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TruckRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return self::store();
            }
            case 'PUT': {
                return self::update();
            }
        }
    }

    /**
     * Get the validation rules that apply to the store request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function store($prefix = '')
    {
        return [
            $prefix . 'driver_id' => 'required',
            $prefix . 'truck_type_id' => 'required',
            $prefix . 'plate_number' => 'string|nullable',
            $prefix . 'model' => 'string|nullable',
            $prefix . 'chassis_number' => 'string|nullable',
            $prefix . 'license_number' => 'string|nullable',
            $prefix . 'license_copy' => 'image|nullable',
        ];
    }

    /**
     * Get the validation rules that apply to the update request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function update($prefix = '')
    {
        return [
            $prefix . 'driver_id' => 'nullable',
            $prefix . 'truck_type_id' => 'nullable',
            $prefix . 'plate_number' => 'string|nullable',
            $prefix . 'model' => 'string|nullable',
            $prefix . 'chassis_number' => 'string|nullable',
            $prefix . 'license_number' => 'string|nullable',
            $prefix . 'license_copy' => 'nullable',
        ];
    }
}
