<?php

namespace Core\Provider\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Core\Auth\Requests\UserRequest;
use Core\Common\Requests\CompanyRequest;
use Core\Financial\Requests\AccountRequest;

class ProviderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return self::store();
            }
            case 'PUT': {
                return self::update();
            }
        }
    }

    /**
     * Get the validation rules that apply to the store request.
     *
     * @return array
     */
    public static function store()
    {
        $array = [
            'name'      => 'string|required',
            'type'      => 'required|in:freelancer,partner',
            'is_active' => 'boolean|nullable',
        ];

        $rules = array_merge(
            $array,
            UserRequest::store(),
            CompanyRequest::store('company.'),
            AccountRequest::store('account.')
        );

        $rules['company.companyable_type'] = '';
        $rules['company.companyable_id']   = '';
        $rules['account.user_id']          = '';
        $rules['account.currency']         = '';

        if(request()->type == 'freelancer') {
            $rules = array_merge($rules, DriverRequest::store('driver.'), TruckRequest::store('truck.'));
            $rules['driver.provider_id'] = '';
            $rules['truck.driver_id']    = '';
        }

        return $rules;
    }

    /**
     * Get the validation rules that apply to the update request.
     *
     * @return array
     */
    public static function update()
    {
        $array = [
            'name'      => 'string|nullable',
            'type'      => 'nullable|in:freelancer,partner',
            'is_active' => 'boolean|nullable',
        ];

        $rules = array_merge(
            $array,
            UserRequest::update(),
            CompanyRequest::update('company.'),
            AccountRequest::update('account.')
        );

        $rules['company.companyable_type'] = '';
        $rules['company.companyable_id']   = '';
        $rules['account.user_id']          = '';
        $rules['account.currency']         = '';

        if(request()->type == 'freelancer') {
            $rules = array_merge($rules, DriverRequest::update('driver.'), TruckRequest::update('truck.'));
            $rules['driver.provider_id'] = '';
            $rules['truck.driver_id']    = '';
        }

        return $rules;
    }
}
