<?php

namespace Core\Provider\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Core\Auth\Requests\UserRequest;

class DriverRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return self::store();
            }
            case 'PUT': {
                return self::update();
            }
        }
    }

    /**
     * Get the validation rules that apply to the store request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function store($prefix = '')
    {
        $provider_id = '';
        $user        = auth()->user();

        if ($user) {
            if ($user->userable_type == 'provider') {
                $provider_id = 'nullable';
            } else {
                $provider_id = 'required';
            }
        }

        $rules = [
            // $prefix . $provider_id,
            $prefix . 'id_copy' => 'file|nullable',
            $prefix . 'driving_license_number' => 'string|nullable',
            $prefix . 'driving_license_copy' => 'file|nullable',
            $prefix . 'sponsor_establishment_name' => 'string|nullable',
            $prefix . 'sponsor_establishment_number' => 'string|nullable',
            $prefix . 'nationality_id' => 'string|nullable',
            $prefix . 'license_id' => 'file|nullable',
            $prefix . 'expiry_date' => 'string|nullable',
        ];

        if(request()->route()->getName() == 'api.v1.drivers.store') {
            $rules = array_merge($rules, UserRequest::store());
        }

        return $rules;
    }

    /**
     * Get the validation rules that apply to the update request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function update($prefix = '')
    {
        $provider_id = '';
        $user        = auth()->user();

        if ($user) {
            if ($user->userable_type == 'provider') {
                $provider_id = 'nullable';
            } else {
                $provider_id = 'required';
            }
        }

        $rules = [
            // $prefix . $provider_id,
            $prefix . 'id_copy' => 'nullable',
            $prefix . 'driving_license_number' => 'string|nullable',
            $prefix . 'driving_license_copy' => 'nullable',
            $prefix . 'sponsor_establishment_name' => 'string|nullable',
            $prefix . 'sponsor_establishment_number' => 'string|nullable',
            $prefix . 'nationality_id' => 'string|nullable',
            $prefix . 'license_id' => 'nullable',
            $prefix . 'expiry_date' => 'string|nullable',
        ];

        if(request()->route()->getName() == 'api.v1.drivers.update') {
            $rules = array_merge($rules, UserRequest::update());
        }

        return $rules;
    }
}
