<?php

namespace Core\Provider\Observers;

use Core\Provider\Models\Provider;

class ProviderObserver
{
    /**
     * Handle the Provider "creating" event.
     *
     * @param  \Core\Provider\Models\Provider  $provider
     * @return void
     */
    public function creating(Provider $provider)
    {
        if (!auth()->user()) {
            $provider->is_active = false;
        }
    }

    /**
     * Handle the Provider "created" event.
     *
     * @param  \Core\Provider\Models\Provider  $provider
     * @return void
     */
    public function created(Provider $provider)
    {
        if($this->routeName() == 'api.v1.providers.store') {
            $provider->user()->create(request()->all());
            $provider->contract()->create();
            $provider->user->account()->create(request()->account ?? []);

            if($provider->type == 'partner') {
                $provider->company()->create(request()->company ?? []);
            }

            if($provider->type == 'freelancer') {
                $provider->driver()->create(request()->driver);
            }
        }
    }

    /**
     * Handle the Provider "saved" event.
     *
     * @param  \Core\Provider\Models\Provider  $provider
     * @return void
     */
    public function saved(Provider $provider)
    {
        if($this->routeName() == 'api.v1.providers.update') {
            $provider->user()->update(request()->except('type', 'driver', 'truck', 'company', 'account', '_method'));
            $provider->user->account()->update(request()->account ?? []);

            if($provider->type == 'partner') {
                $provider->company()->update(request()->company ?? []);
            }
            
            if($provider->type == 'freelancer') {
                $provider->driver()->update(request()->driver);
                $provider->driver->truck()->update(request()->truck);
            }
        }
    }

    /**
     * Get the current route name.
     *
     * @return string
     */
    protected function routeName()
    {
        return request()->route() ? request()->route()->getName() : '';
    }
}
