<?php

namespace Core\Provider\Observers;

use Core\Provider\Models\Driver;

class DriverObserver
{
    /**
     * Handle the Driver "creating" event.
     *
     * @param  \Core\Provider\Models\Driver  $driver
     * @return void
     */
    public function creating(Driver $driver)
    {
        $user = auth()->user();
        if ($user && $user->userable_type == 'provider') {
            $driver->provider_id = $user->userable_id;
        }
    }

    /**
     * Handle the Driver "created" event.
     *
     * @param  \Core\Provider\Models\Driver  $driver
     * @return void
     */
    public function created(Driver $driver)
    {
        if($this->routeName() == 'api.v1.drivers.store') {
            $driver->user()->create(request()->all());
        }

        // this means the current user is provider (Freelancer), check out the ProviderObserver
        if($this->routeName() == 'api.v1.providers.store') {
            $driver->truck()->create(request()->truck);
        }
    }

    /**
     * Handle the Driver "saved" event.
     *
     * @param  \Core\Provider\Models\Driver  $driver
     * @return void
     */
    public function saved(Driver $driver)
    {
        if($this->routeName() == 'api.v1.drivers.update') {
            $driver->user()->update(request()->only(array_keys(\Core\Auth\Requests\UserRequest::update())));
        }
    }

    /**
     * Get the current route name.
     *
     * @return string
     */
    protected function routeName()
    {
        return request()->route() ? request()->route()->getName() : '';
    }
}
