<?php

namespace Core\Provider;

use Illuminate\Support\ServiceProvider;
use Core\Base\Traits\ServiceProvider\File;
use Illuminate\Database\Eloquent\Relations\Relation;
use Core\Provider\Models\Provider;
use Core\Provider\Observers\ProviderObserver;
use Core\Provider\Models\Driver;
use Core\Provider\Observers\DriverObserver;

class ModuleServiceProvider extends ServiceProvider
{
    use File;

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->loadFiles(__DIR__, 'provider');
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        Relation::enforceMorphMap([
            'provider'   => Models\Provider::class,
            'driver'     => Models\Driver::class,
            'truck'      => Models\Truck::class,
            'truck_type' => Models\TruckType::class
        ]);

        Provider::observe(ProviderObserver::class);
        Driver::observe(DriverObserver::class);
    }
}
