<?php

namespace Core\Provider\Models;

use Core\Base\Models\Base;
use Illuminate\Database\Eloquent\Casts\Attribute;

class TruckType extends Base
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'truck_types';

    /**
     * Set the image.
     *
     * @param string $value
     */
    public function setImageAttribute($value) : void
    {
        $this->setFilePath($value, 'image');
    }

    /**
     * get the image.
     *
     * @param string $value
     */
    public function getImageAttribute($value) : string
    {
        return $this->getFilePath($value);
    }

    /**
     * get the trucks.
     */
    public function trucks()
    {
        return $this->hasMany(Truck::class, 'truck_type_id');
    }

    /**
     * get the contract items.
     */
    public function contractItems()
    {
        return $this->hasMany(\Core\Contract\Models\ContractItem::class, 'truck_type_id');
    }

    /**
     * get the shipments.
     */
    public function shipments()
    {
        return $this->hasMany(\Core\Shipment\Models\Shipment::class, 'truck_type_id');
    }

    /**
     * Interact with the shipment types.
     *
     * @return \Illuminate\Database\Eloquent\Casts\Attribute
     */
    public function shipmentTypes(): Attribute
    {
        return new Attribute(
            get: fn ($value) => $value,
            set: fn ($value) => $value
        );
    }
}
