<?php

namespace Core\Provider\Models;

use Core\Base\Models\Base;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Truck extends Base
{
    /**
     * The "booted" method of the model.
     *
     * @return void
     */
    protected static function booted()
    {
        static::addGlobalScope(new Scopes\TruckByProviderIdScope);
    }

    /**
     * get the driver.
     */
    public function driver()
    {
        return $this->belongsTo(Driver::class, 'driver_id');
    }

    /**
     * get the type.
     */
    public function type()
    {
        return $this->belongsTo(TruckType::class, 'truck_type_id');
    }

    /**
     * Interact with the license copy.
     *
     * @return \Illuminate\Database\Eloquent\Casts\Attribute
     */
    public function licenseCopy(): Attribute
    {
        return new Attribute(
            get: fn ($value) => $this->getFilePath($value),
            set: fn ($value) => $this->setFilePath($value, 'license_copy')
        );
    }
}
