<?php
 
namespace Core\Provider\Models\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;
use Core\Provider\Models\Provider;

class TruckByProviderIdScope implements Scope
{
    /**
     * Apply the scope to a given Eloquent query builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {
        if ((request()->getMethod() == 'GET' && request()->provider_id) || 
            (auth()->user() && auth()->user()->userable_type == 'provider')) {
            $provider = request()->provider_id ?
                        Provider::find(request()->provider_id) :
                        auth()->user()->userable;
            $ids = $provider->type == 'freelancer' ?
                   $provider->driver->pluck('id') :
                   $provider->drivers->pluck('id');

            $builder->whereIn('driver_id', $ids);
        }
    }
}