<?php

namespace Core\Provider\Models;

use Core\Base\Models\Base;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Driver extends Base
{
    /**
     * The "booted" method of the model.
     *
     * @return void
     */
    protected static function booted()
    {
        static::addGlobalScope(new Scopes\ProviderIdScope);
    }

    /**
     * get the user.
     */
    public function user()
    {
        return $this->morphOne(\Core\Auth\Models\User::class, 'userable');
    }

    /**
     * get the provider.
     */
    public function provider()
    {
        return $this->belongsTo(Provider::class, 'provider_id');
    }

    /**
     * get the trucks (in case of partner).
     */
    public function trucks()
    {
        return $this->hasMany(Truck::class, 'driver_id');
    }

    /**
     * get the truck (in case of freelancer).
     */
    public function truck()
    {
        return $this->hasOne(Truck::class, 'driver_id');
    }

    /**
     * get the shipments.
     */
    public function shipments()
    {
        return $this->hasMany(\Core\Shipment\Models\Shipment::class, 'driver_id');
    }

    /**
     * Interact with the id copy.
     *
     * @return \Illuminate\Database\Eloquent\Casts\Attribute
     */
    public function idCopy(): Attribute
    {
        return new Attribute(
            get: fn ($value) => $this->getFilePath($value),
            set: fn ($value) => $this->setFilePath($value, 'id_copy')
        );
    }

    /**
     * Interact with the driving license copy.
     *
     * @return \Illuminate\Database\Eloquent\Casts\Attribute
     */
    public function drivingLicenseCopy(): Attribute
    {
        return new Attribute(
            get: fn ($value) => $this->getFilePath($value),
            set: fn ($value) => $this->setFilePath($value, 'driving_license_copy')
        );
    }

    /**
     * Interact with the license id.
     *
     * @return \Illuminate\Database\Eloquent\Casts\Attribute
     */
    public function licenseId(): Attribute
    {
        return new Attribute(
            get: fn ($value) => $this->getFilePath($value),
            set: fn ($value) => $this->setFilePath($value, 'license_id')
        );
    }
}
