<?php

namespace Core\Provider\Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Core\Provider\Models\Provider as Model;
use Core\Provider\Models\TruckType;
use Core\Provider\Models\Truck;
use Core\Auth\Models\User;

class ProviderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $dump_value = '123456';

        // partner
        $partner = Model::factory()->create(['type' => 'partner']);
        $user = User::factory()->make([
            'name'  => $partner->name,
            'email' => 'partner@example.com'
        ]);
        $user = $user->toArray();
        $user['password'] = $dump_value;
        $partner->user()->create($user);
        $partner->company()->create([]);
        $partner->user->account()->create([]);
        $contract = $partner->contract()->create();

        $contract->items()->create([
            'from_city_id'     => 3,
            'to_city_id'       => 6,
            'truck_type_id'    => 1,
            'shipment_type_id' => 1,
            'price'            => 800.00
        ]);

        $driver = $partner->drivers()->create();
        $user = User::factory()->make([
            'name'  => 'partner driver',
            'email' => 'partner_driver@example.com'
        ]);
        $user = $user->toArray();
        $user['password'] = $dump_value;
        $driver->user()->create($user);
        Truck::factory()->create(['driver_id' => $driver->id, 'truck_type_id' => 1]);

        // freelancer
        $freelancer = Model::factory()->create(['type' => 'freelancer']);
        $user = User::factory()->make([
            'name'  => $freelancer->name,
            'email' => 'freelancer@example.com'
        ]);
        $user = $user->toArray();
        $user['password'] = $dump_value;
        $freelancer->user()->create($user);
        $freelancer->user->account()->create([]);
        $contract = $freelancer->contract()->create();

        $contract->items()->create([
            'from_city_id'     => 3,
            'to_city_id'       => 6,
            'truck_type_id'    => 1,
            'shipment_type_id' => 1,
            'price'            => 700.00
        ]);

        $driver = $freelancer->driver()->create();
        Truck::factory()->create(['driver_id' => $driver->id, 'truck_type_id' => 1]);
    }
}
