<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrucksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trucks', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->foreignId('driver_id');
            $table->foreign('driver_id')->references('id')->on('drivers')->onDelete('cascade');

            $table->foreignId('truck_type_id');
            $table->foreign('truck_type_id')->references('id')->on('truck_types')->onDelete('cascade');

            $table->string('plate_number')->nullable();
            $table->string('model')->nullable();
            $table->string('chassis_number')->nullable();
            $table->string('license_number')->nullable();
            $table->string('license_copy')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('trucks');
    }
}
