<?php

namespace Core\Provider\Database\Factories;

use Core\Provider\Models\Truck as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class TruckFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $driver = \Core\Provider\Models\Driver::factory()->create();
        $truck_type = \Core\Provider\Models\TruckType::factory()->create();
        
        return [
            'driver_id' => $driver->id,
            'truck_type_id' => $truck_type->id,
            'plate_number' => $this->faker->text(100),
            'model' => $this->faker->text(100),
            'chassis_number' => $this->faker->text(100),
            'license_number' => $this->faker->text(100),
            'license_copy' => $this->faker->text(100),
        ];
    }
}
