<?php

namespace Core\Provider\Database\Factories;

use Core\Provider\Models\Provider as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProviderFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name'      => $this->faker->name,
            'type'      => $this->faker->randomElement(['freelancer', 'partner']),
            'is_active' => true
        ];
    }
}
