<?php

namespace Core\Provider\Database\Factories;

use Core\Provider\Models\Driver as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class DriverFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $provider = \Core\Provider\Models\Provider::factory()->create();
        return [
            'provider_id' => $provider->id,
            'id_copy' => $this->faker->text(100),
            'driving_license_number' => $this->faker->text(100),
            'driving_license_copy' => $this->faker->text(100),
            'sponsor_establishment_name' => $this->faker->text(100),
            'sponsor_establishment_number' => $this->faker->text(100),
            'nationality_id' => $this->faker->text(100),
            'license_id' => $this->faker->text(100),
            'expiry_date' => $this->faker->text(100),
        ];
    }
}
