<?php

namespace Core\Provider\Controllers\API\V1;

use Core\Provider\Requests\DriverRequest as FormRequest;
use Core\Provider\Models\Driver as Model;
use Core\Auth\Models\User;
use Core\Provider\Resources\DriverResource as Resource;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class DriverController extends \Core\Base\Controllers\API\Controller
{
    /**
     * Init.
     * @param FormRequest $request
     * @param Model       $model
     * @param string      $resource
     */
    public function __construct(FormRequest $request, Model $model, $resource = Resource::class)
    {
        parent::__construct($request, $model, $resource);
    }
    public function updateDriver(Request $request,$id)
    {
        // dd($request);
        
        $validatedData = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:users,email,' . $id,
            'avatar' => 'nullable|image|mimes:jpg,jpeg,png',
            'password' => 'nullable|confirmed|min:6',
            'phone' => 'required|string|max:20',
            'national_id' => 'required|string|max:20',
    
            'id_copy' => 'nullable|file|mimes:jpg,jpeg,png,pdf',
            'driving_license_number' => 'nullable|string|max:255',
            'driving_license_copy' => 'nullable|file|mimes:jpg,jpeg,png,pdf',
            'license_id' => 'nullable|file|mimes:jpg,jpeg,png,pdf',
            'expiry_date' => 'nullable',
            'sponsor_establishment_name' => 'nullable|string|max:255',
            'sponsor_establishment_number' => 'nullable|string|max:255',
        ]);
    
        
        $user = User::findOrFail($id);
        $driver = Model::findOrFail($user->userable_id);
        
        $user->name = $request->input('name');
        $user->email = $request->input('email');
        $user->phone = $request->input('phone');
        $user->national_id = $request->input('national_id');
   
        if ($request->filled('password')) {
            $user->password = Hash::make($request->input('password'));
        }
    
        // Handle profile picture update
        if ($request->hasFile('avatar')) {
            $value           = $request->file('avatar');
            $extension       = $value->extension();
            $attachment_name = time() . '_' . md5(uniqid(rand(), true)) . '.' . $extension;
    
            $value->move(public_path('uploads/attachments'), $attachment_name);
            $user->avatar = $value;
        }
    
        $user->save();
    
        
        $driver->driving_license_number = $request->input('driving_license_number');
        $driver->expiry_date = $request->input('expiry_date');
        $driver->sponsor_establishment_name = $request->input('sponsor_establishment_name');
        $driver->sponsor_establishment_number = $request->input('sponsor_establishment_number');
    
        // Handle file uploads for the driver
        if ($request->hasFile('id_copy')) {
            $value           = $request->file('id_copy');
            $extension       = $value->extension();
            $attachment_name = time() . '_' . md5(uniqid(rand(), true)) . '.' . $extension;
    
            $value->move(public_path('uploads/attachments'), $attachment_name);
            $driver->id_copy = $value;
        }
    
        if ($request->hasFile('driving_license_copy')) {
            $value           = $request->file('driving_license_copy');
            $extension       = $value->extension();
            $attachment_name = time() . '_' . md5(uniqid(rand(), true)) . '.' . $extension;
    
            $value->move(public_path('uploads/attachments'), $attachment_name);
            $driver->driving_license_copy = $value;
        }
    
        if ($request->hasFile('license_id')) {
            $value           = $request->file('license_id');
            $extension       = $value->extension();
            $attachment_name = time() . '_' . md5(uniqid(rand(), true)) . '.' . $extension;
    
            $value->move(public_path('uploads/attachments'), $attachment_name);
            $driver->license_id = $value;
        }
    
        $driver->save();
        $d=new Resource($driver);
    
        return $this->sendResponse($d,'User updated successfully.');
    }
}
