<?php

Route::group(['prefix' => 'api', 'middleware' => ['auth:api']], function () {
    # V1
    Route::namespace('Core\Financial\Controllers\API\V1')->prefix('v1')->name('api.v1.')->group(function () {
        Route::apiResource('wallets', 'WalletController');
        Route::apiResource('invoices', 'InvoiceController');
        Route::apiResource('invoice_items', 'InvoiceItemController');
        Route::apiResource('categories', 'CategoryController');
        Route::apiResource('requests', 'RequestController');
        Route::apiResource('wallet_transactions', 'WalletTransactionController')->only(['index', 'show']);
        Route::apiResource('accounts', 'AccountController');
        Route::apiResource('promotions', 'PromotionController');
        Route::apiResource('banks', 'BankController');
    });
});
