<?php

namespace Core\Financial\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;

class WalletTransactionResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'                   => $this->id,
            'wallet_id'            => $this->wallet_id,
            'transactionable_type' => $this->transactionable_type,
            'transactionable_id'   => $this->transactionable_id,
            'amount'               => $this->amount,
            $this->mergeWhen($request->route()->getName() == 'api.v1.wallet_transactions.show', [
                'wallet'          => new WalletResource($this->wallet),
                'transactionable' => $this->transactionable
            ])
        ];
    }
}
