<?php

namespace Core\Financial\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Auth\Resources\UserResource;

class WalletResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $route_name = $request->route()->getName();

        return [
            'id'       => $this->id,
            'user_id'  => $this->user_id,
            'balance'  => $this->balance,
            'currency' => $this->currency,
            $this->mergeWhen($route_name == 'api.v1.wallets.show', [
                'user'         => new UserResource($this->user),
                'transactions' => WalletTransactionResource::collection($this->transactions),
            ]),
            $this->mergeWhen($route_name == 'api.v1.auth.me' && request()->transactions, [
                'transactions' => WalletTransactionResource::collection($this->transactions)
            ])
        ];
    }
}
