<?php

namespace Core\Financial\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Shipment\Resources\ShipmentResource;
use Core\Provider\Resources\ProviderResource;
use Core\Financial\Resources\InvoiceItemResource;

class RequestResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $route_name = $request->route()->getName();
        return [
            'id'                   => $this->id,
            'category_id'          => $this->category_id,
            'requestable_type'     => $this->requestable_type,
            'requestable_id'       => $this->requestable_id,
            'beneficiaryable_type' => $this->beneficiaryable_type,
            'beneficiaryable_id'   => $this->beneficiaryable_id,
            'status'               => $this->status,
            'type'                 => $this->type,
            'total'                => $this->total,
            'currency'             => $this->currency,
            'description'          => $this->description,
            $this->mergeWhen($route_name == 'api.v1.requests.show', [
                'shipment'          => $this->when($this->requestable_type == 'shipment', new ShipmentResource($this->requestable)),
                'promotion_tracker' => $this->when($this->requestable_type == 'promotion_tracker', new PromotionTrackerResource($this->requestable)),
                'provider'          => $this->when($this->beneficiaryabl_type == 'provider', new ProviderResource($this->beneficiaryabl)),
                'invoice_item'      => new InvoiceItemResource($this->invoiceItem),
            ]),
            $this->mergeWhen($route_name == 'api.v1.requests.show' || $route_name == 'api.v1.shipments.show', [
                'category' => new CategoryResource($this->category),
            ])
        ];
    }
}
