<?php

namespace Core\Financial\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Auth\Resources\UserResource;

class PromotionTrackerResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'           => $this->id,
            'promotion_id' => $this->promotion_id,
            'user_id'      => $this->user_id,
            'status'       => $this->status,
            'details'      => $this->details,
            $this->mergeWhen($request->route()->getName() == 'api.v1.promotions_trackers.show', [
                'promotion' => new PromotionResource($this->promotion),
                'user'      => new UserResource($this->user),
                'request'   => new RequestResource($this->request)
            ]),
        ];
    }
}
