<?php

namespace Core\Financial\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;

class PromotionResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'          => $this->id,
            'name'        => $this->name,
            'description' => $this->description,
            'status'      => $this->status,
            'details'     => $this->details,
            $this->mergeWhen($request->route()->getName() == 'api.v1.promotions.show', [
                'trackers' => PromotionTrackerResource::collection($this->trackers)
            ])
        ];
    }
}
