<?php

namespace Core\Financial\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Shipment\Resources\OrderResource;
use Core\Common\Resources\AttachmentResource;

class InvoiceResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'               => $this->id,
            'code'             => $this->code,
            'invoiceable_type' => $this->invoiceable_type,
            'invoiceable_id'   => $this->invoiceable_id,
            'status'           => $this->status,
            'total'            => $this->total,
            'due_date'         => $this->due_date,
            'currency'         => $this->currency,
            $this->mergeWhen($request->route()->getName() == 'api.v1.invoices.show', [
                'order'              => $this->when($this->invoiceable_type == 'order', new OrderResource($this->invoiceable)),
                'items'              => InvoiceItemResource::collection($this->items),
                'attachments'        => AttachmentResource::collection($this->attachments),
                'wallet_transaction' => new WalletTransactionResource($this->walletTransaction),
            ])
        ];
    }
}
