<?php

namespace Core\Financial\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Shipment\Resources\ShipmentResource;

class InvoiceItemResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'invoice_id'    => $this->invoice_id,
            'itemable_type' => $this->itemable_type,
            'itemable_id'   => $this->itemable_id,
            'price'         => $this->price,
            $this->mergeWhen($request->route()->getName() == 'api.v1.invoice_items.show', [
                'shipment'     => $this->when($this->itemable_type == 'shipment', new ShipmentResource($this->itemable)),
                'invoice_item' => $this->when($this->itemable_type == 'invoice', new InvoiceResource($this->itemable)),
                'invoice'      => new InvoiceResource($this->invoice),
            ])
        ];
    }
}
