<?php

namespace Core\Financial\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;

class CategoryResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'   => $this->id,
            'name' => $this->name,
            'type' => $this->type,
            $this->mergeWhen($request->route()->getName() == 'api.v1.categories.show', [
                'requests' => RequestResource::collection($this->requests)
            ])
        ];
    }
}
