<?php

namespace Core\Financial\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Auth\Resources\UserResource;

class AccountResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'                 => $this->id,
            'user_id'            => $this->user_id,
            'bank'               => $this->bank,
            'bank_address'       => $this->bank_address,
            'bank_clearing_code' => $this->bank_clearing_code,
            'bank_code'          => $this->bank_code,
            'account_number'     => $this->account_number,
            'name'               => $this->name,
            'address'            => $this->address,
            'currency'           => $this->currency,
            $this->mergeWhen($request->route()->getName() == 'api.v1.accounts.show', [
                'user' => new UserResource($this->user),
            ])
        ];
    }
}
