<?php

namespace Core\Financial\Requests;

use Illuminate\Foundation\Http\FormRequest;

class WalletTransactionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return [
                    'wallet_id' => 'required',
                    'transactionable_type' => 'string|nullable',
                    'transactionable_id' => 'integer|nullable',
                    'amount' => 'integer|required',

                ];
            }
            case 'PUT': {
                return [
                    'wallet_id' => 'required',
                    'transactionable_type' => 'string|nullable',
                    'transactionable_id' => 'integer|nullable',
                    'amount' => 'integer|required',

                ];
            }
        }
    }
}
