<?php

namespace Core\Financial\Requests;

use Illuminate\Foundation\Http\FormRequest;

class WalletRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return [
                    'user_id' => 'required',
                    'balance' => 'numeric|required',
                    'currency' => 'string|required',

                ];
            }
            case 'PUT': {
                return [
                    'user_id' => 'required',
                    'balance' => 'numeric|required',
                    'currency' => 'string|required',

                ];
            }
        }
    }
}
