<?php

namespace Core\Financial\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RequestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return [
                    'category_id' => 'required',
                    'requestable_type' => 'string|nullable',
                    'requestable_id' => 'integer|nullable',
                    'beneficiaryable_type' => 'string|nullable',
                    'beneficiaryable_id' => 'integer|nullable',
                    'status' => 'string|nullable',
                    'type' => 'string|required',
                    'total' => 'integer|nullable',
                    'currency' => 'string|required',
                    'description' => 'nullable',

                ];
            }
            case 'PUT': {
                return [
                    'category_id' => 'required',
                    'requestable_type' => 'string|nullable',
                    'requestable_id' => 'integer|nullable',
                    'beneficiaryable_type' => 'string|nullable',
                    'beneficiaryable_id' => 'integer|nullable',
                    'status' => 'string|nullable',
                    'type' => 'string|required',
                    'total' => 'integer|nullable',
                    'currency' => 'string|required',
                    'description' => 'nullable',

                ];
            }
        }
    }
}
