<?php

namespace Core\Financial\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PromotionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return [
                    'name'                                         => 'string|required',
                    'description'                                  => 'nullable',
                    'status'                                       => 'string|nullable',
                    'details'                                      => 'required|array',
                    'details.conditions'                           => 'required|array',
                    'details.actions'                              => 'required|array',
                    'details.conditions.achievement'               => 'required|in:all,any',
                    'details.conditions.delivered_shipments'       => 'required|array',
                    'details.conditions.delivered_shipments.value' => 'required|integer',
                    'details.conditions.start_time'                => 'array',
                    'details.conditions.start_time.value'          => 'date_format:Y-m-d H:i:s',
                    'details.conditions.end_time'                  => 'array',
                    'details.conditions.end_time.value'            => 'date_format:Y-m-d H:i:s',
                    'details.conditions.from_city_id'              => 'array',
                    'details.conditions.from_city_id.value'        => 'integer',
                    'details.conditions.to_city_id'                => 'array',
                    'details.conditions.to_city_id.value'          => 'integer',
                    'details.conditions.truck_type_id'             => 'array',
                    'details.conditions.truck_type_id.value'       => 'integer',
                    'details.conditions.shipment_type_id'          => 'array',
                    'details.conditions.shipment_type_id.value'    => 'integer',
                    'details.actions.total'                        => 'required|array',
                    'details.actions.total.type'                   => 'required|in:fixed,percentage',
                    'details.actions.total.value'                  => 'required|numeric',
                ];
            }
            case 'PUT': {
                return [
                    'name'                                         => 'string|required',
                    'description'                                  => 'nullable',
                    'status'                                       => 'string|nullable',
                    'details'                                      => 'required|array',
                    'details.conditions'                           => 'required|array',
                    'details.actions'                              => 'required|array',
                    'details.conditions.achievement'               => 'required|in:all,any',
                    'details.conditions.delivered_shipments'       => 'required|array',
                    'details.conditions.delivered_shipments.value' => 'required|integer',
                    'details.conditions.start_time'                => 'array',
                    'details.conditions.start_time.value'          => 'date_format:Y-m-d H:i:s',
                    'details.conditions.end_time'                  => 'array',
                    'details.conditions.end_time.value'            => 'date_format:Y-m-d H:i:s',
                    'details.conditions.from_city_id'              => 'array',
                    'details.conditions.from_city_id.value'        => 'integer',
                    'details.conditions.to_city_id'                => 'array',
                    'details.conditions.to_city_id.value'          => 'integer',
                    'details.conditions.truck_type_id'             => 'array',
                    'details.conditions.truck_type_id.value'       => 'integer',
                    'details.conditions.shipment_type_id'          => 'array',
                    'details.conditions.shipment_type_id.value'    => 'integer',
                    'details.actions.total'                        => 'required|array',
                    'details.actions.total.type'                   => 'required|in:fixed,percentage',
                    'details.actions.total.value'                  => 'required|numeric',
                ];
            }
        }
    }
}
