<?php

namespace Core\Financial\Requests;

use Illuminate\Foundation\Http\FormRequest;

class InvoiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return [
                    'invoiceable_type' => 'string|nullable',
                    'invoiceable_id' => 'integer|nullable',
                    'status' => 'string|nullable',
                    'total' => 'integer|nullable',
                    'due_date' => 'date|nullable',

                ];
            }
            case 'PUT': {
                return [
                    'invoiceable_type' => 'string|nullable',
                    'invoiceable_id' => 'integer|nullable',
                    'status' => 'string|nullable',
                    'total' => 'integer|nullable',
                    'due_date' => 'date|nullable',

                ];
            }
        }
    }
}
