<?php

namespace Core\Financial\Requests;

use Illuminate\Foundation\Http\FormRequest;

class InvoiceItemRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return [
                    'invoice_id' => 'required',
                    'itemable_type' => 'string|nullable',
                    'itemable_id' => 'integer|nullable',
                    'price' => 'integer|required',

                ];
            }
            case 'PUT': {
                return [
                    'invoice_id' => 'required',
                    'itemable_type' => 'string|nullable',
                    'itemable_id' => 'integer|nullable',
                    'price' => 'integer|required',

                ];
            }
        }
    }
}
