<?php

namespace Core\Financial\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AccountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return self::store();
            }
            case 'PUT': {
                return self::update();
            }
        }
    }

    /**
     * Get the validation rules that apply to the store request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function store($prefix = '')
    {
        return [
            $prefix . 'user_id' => 'required',
            $prefix . 'bank' => 'string|nullable',
            $prefix . 'bank_address' => 'nullable',
            $prefix . 'bank_clearing_code' => 'string|nullable',
            $prefix . 'bank_code' => 'string|nullable',
            $prefix . 'account_number' => 'string|nullable',
            $prefix . 'name' => 'string|nullable',
            $prefix . 'address' => 'nullable',
            $prefix . 'currency' => 'string|required',
        ];
    }

    /**
     * Get the validation rules that apply to the update request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function update($prefix = '')
    {
        return [
            $prefix . 'user_id' => 'required',
            $prefix . 'bank' => 'string|nullable',
            $prefix . 'bank_address' => 'nullable',
            $prefix . 'bank_clearing_code' => 'string|nullable',
            $prefix . 'bank_code' => 'string|nullable',
            $prefix . 'account_number' => 'string|nullable',
            $prefix . 'name' => 'string|nullable',
            $prefix . 'address' => 'nullable',
            $prefix . 'currency' => 'string|required',
        ];
    }
}
