<?php

namespace Core\Financial\PaymentGateways;

use GuzzleHttp\Client;

class Urway
{
    /**
     * http client.
     *
     * @var \GuzzleHttp\Client
     */
    protected $client;

    /**
     * the payload.
     *
     * @var array
     */
    protected $payload;

    /**
     * the endpoint.
     *
     * @var string
     */
    protected $endpoint = 'URWAYPGService/transaction/jsonProcess/JSONrequest';

    /**
     * init.
     *
     * @param  array $payload
     * @return void
     */
    public function __construct(array $payload)
    {
        $this->client = new Client([
            'base_uri' => $this->config()['base_url'] . '/',
            'headers'  => [
                'Content-Type' => 'application/json',
                'Accept'       => 'application/json'
            ]
        ]);

        $current_payload = [
            'terminalId' => $this->config()['terminal_id'],
            'password'   => $this->config()['password']
        ];

        if (request()->callback_url) {
            $current_payload['udf2'] = request()->callback_url;
        }

        $this->payload = array_merge($payload, $current_payload);

        $this->setRequestHash();
    }

    /**
     * get the configuration
     * 
     * @return array
     */
    protected function config()
    {
        return config('core_financial.payment.gateways.urway');
    }

    /**
     * set the request hash
     * 
     * @return void
     */
    protected function setRequestHash()
    {
        $this->payload['requestHash'] = hash(
            'sha256', 
            $this->payload['trackid'] . '|' .
            $this->payload['terminalId'] . '|' .
            $this->payload['password'] . '|' .
            $this->config()['merchant_key'] . '|' .
            $this->payload['amount'] . '|' .
            $this->payload['currency']
        );
    }

    /**
     * transaction type is Purchase.
     *
     * @return array
     */
    public function purchase()
    {
        $result = [];

        $this->payload['action'] = '1';

        $request = $this->client->post($this->endpoint, [
            'json' => $this->payload
        ]);

        $response = json_decode($request->getBody());

        logger()->channel('payment-gateways')->info(json_encode($response));

        if ($response->targetUrl && $response->payid) {
            $result['redirect_to'] = $response->targetUrl . '?paymentid=' . $response->payid;
        }

        return $result;
    }

    /**
     * transaction type is Transaction Inquiry.
     *
     * @return array
     */
    public function transactionInquiry()
    {
        $this->payload['action'] = '10';

        $request = $this->client->post($this->endpoint, [
            'json' => $this->payload
        ]);

        $response = json_decode($request->getBody());

        logger()->channel('payment-gateways')->info(json_encode($response));

        return (array) $response;
    }

    /**
     * transaction type is B2B Split payment.
     *
     * @return array
     */
    public function transfer()
    {
        $this->endpoint = 'PGServiceB2B/transaction/jsonProcess/JSONrequest';

        $this->payload['action'] = '16';

        $request = $this->client->post($this->endpoint, [
            'json' => $this->payload
        ]);

        $response = json_decode($request->getBody());

        logger()->channel('payment-gateways')->info(json_encode($response));

        return (array) $response;
    }
}