<?php

namespace Core\Financial\Observers;

use Core\Financial\Models\WalletTransaction;

class WalletTransactionObserver
{
    /**
     * Handle the WalletTransaction "created" event.
     *
     * @param  \Core\Financial\Models\WalletTransaction $wallet_transaction
     * @return void
     */
    public function created(WalletTransaction $wallet_transaction)
    {
        $wallet = $wallet_transaction->wallet;
        $wallet->update(['balance' => $wallet->balance + $wallet_transaction->amount]);
    }
}
