<?php

namespace Core\Financial\Observers;

use Core\Financial\Models\PromotionTracker;
use Core\Financial\Models\Invoice;

class PromotionTrackerObserver
{
    /**
     * Handle the PromotionTracker "updated" event.
     *
     * @param  \Core\Financial\Models\PromotionTracker  $promotion_tracker
     * @return void
     */
    public function updated(PromotionTracker $promotion_tracker)
    {
        if ($promotion_tracker->wasChanged('status') && 
            $promotion_tracker->status == $this->statuses()['achieved']['value']) {

            $request = $promotion_tracker->request()->create([
                'category_id'          => 1, // for now static, we have to get/create Deposits category
                'beneficiaryable_type' => $promotion_tracker->user->userable_type,
                'beneficiaryable_id'   => $promotion_tracker->user->userable_id,
                'status'               => config('core_financial.statuses.request.paid.value'),
                'total'                => $promotion_tracker->details['actions']['total']['current_value']
            ]);


            $total   = $request->total;
            $invoice = Invoice::create([
                'invoiceable_type' => 'request',
                'status'           => config('core_financial.statuses.invoice.paid.value'),
                'total'            => $total,
                'due_date'         => date('Y-m-d')
            ]);

            $invoice->items()->create($request->invoiceItem()->make(['price' => $total])->toArray());
            $wallet = $promotion_tracker->user->wallet;
            handle_wallet_transaction($wallet, $invoice->walletTransaction()->make(['amount' => $total])->toArray());
        }
    }

    /**
     * promotion statuses config
     *
     * @return array
     */
    protected function statuses()
    {
        return config('core_financial.statuses.promotion');
    }
}
