<?php

namespace Core\Financial\Observers;

use Core\Financial\Models\Invoice;

class InvoiceObserver
{
    /**
     * Handle the Invoice "updated" event.
     *
     * @param  \Core\Financial\Models\Invoice  $invoice
     * @return void
     */
    public function updated(Invoice $invoice)
    {
        if ($invoice->invoiceable_type == 'order' && $invoice->status == $this->statuses()['paid']['value']) {

            $invoice->invoiceable->update(['status' => config('core_shipment.statuses.order.paid.value')]);

            if (!$invoice->invoiceable->shipper->contract) {
                foreach ($invoice->items as $item) {
                    $item->itemable->update(['status' => $this->shipmentStatuses()['ready']['value']]);
                }
            }
        }
    }

    /**
     * invoice statuses config
     *
     * @return array
     */
    protected function statuses()
    {
        return config('core_financial.statuses.invoice');
    }

    /**
     * shipment statuses config
     *
     * @return array
     */
    protected function shipmentStatuses()
    {
        return config('core_shipment.statuses.shipment');
    }
}
