<?php

namespace Core\Financial\Notifications;

use Core\Common\Notifications\Notification;
use Core\Financial\Models\Invoice;

class PendingInvoice extends Notification
{
    /**
     * Create a new notification instance.
     *
     * @param  Invoice $invoice
     * @return void
     */
    public function __construct(Invoice $invoice)
    {
        $this->data['notificationable_type'] = $invoice->getMorphClass();
        $this->data['title']   = 'Pending Invoice';
        $this->data['body']    = 'this invoice has been paid offline and you need to review it';
        $this->data['payload'] = [
            'id'       => (string) $invoice->id,
            'status'   => $invoice->status,
            'total'    => (string) $invoice->total,
            'due_date' => $invoice->due_date,
            'currency' => $invoice->currency
        ];
    }
}
