<?php

namespace Core\Financial;

use Illuminate\Support\ServiceProvider;
use Core\Base\Traits\ServiceProvider\File;
use Illuminate\Database\Eloquent\Relations\Relation;

class ModuleServiceProvider extends ServiceProvider
{
    use File;

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->loadFiles(__DIR__, 'financial');
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        Relation::enforceMorphMap([
            'wallet'             => Models\Wallet::class,
            'wallet_transaction' => Models\WalletTransaction::class,
            'invoice'            => Models\Invoice::class,
            'invoice_item'       => Models\InvoiceItem::class,
            'category'           => Models\Category::class,
            'request'            => Models\Request::class,
            'account'            => Models\Account::class,
            'promotion'          => Models\Promotion::class,
            'promotion_tracker'  => Models\PromotionTracker::class,
            'BANK-TRANSFER'      => Models\WalletTransaction::class, // this is a temp fix (as we store this value in transactionable_type)
            'Bank'               => Models\Bank::class
        ]);

        Models\Invoice::observe(Observers\InvoiceObserver::class);
        Models\WalletTransaction::observe(Observers\WalletTransactionObserver::class);
        Models\PromotionTracker::observe(Observers\PromotionTrackerObserver::class);
    }
}
