<?php

namespace Core\Financial\Models;

use Core\Base\Models\Base;

class WalletTransaction extends Base
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'wallet_transactions';

    /**
     * get the wallet.
     */
    public function wallet()
    {
        return $this->belongsTo(Wallet::class, 'wallet_id');
    }

    /**
     * Get the parent transactionable model.
     */
    public function transactionable()
    {
        return $this->morphTo(__FUNCTION__, 'transactionable_type', 'transactionable_id');
    }
}
