<?php

namespace Core\Financial\Models;

use Core\Base\Models\Base;

class Request extends Base
{
    /**
     * get the category.
     */
    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    /**
     * Get the parent requestable model.
     */
    public function requestable()
    {
        return $this->morphTo();
    }

    /**
     * Get the parent beneficiaryable model.
     */
    public function beneficiaryable()
    {
        return $this->morphTo();
    }

    /**
     * get the invoice item.
     */
    public function invoiceItem()
    {
        return $this->morphOne(\Core\Financial\Models\InvoiceItem::class, 'itemable');
    }
}
