<?php

namespace Core\Financial\Models;

use Core\Base\Models\Base;

class PromotionTracker extends Base
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'promotions_trackers';

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'details' => 'array'
    ];

    /**
     * The "booted" method of the model.
     *
     * @return void
     */
    protected static function booted()
    {
        static::addGlobalScope(new Scopes\StatusScope);
    }

    /**
     * get the promotion.
     */
    public function promotion()
    {
        return $this->belongsTo(Promotion::class, 'promotion_id');
    }

    /**
     * get the user.
     */
    public function user()
    {
        return $this->belongsTo(\Core\Auth\Models\User::class, 'user_id');
    }

    /**
     * get the request.
     */
    public function request()
    {
        return $this->morphOne(Request::class, 'requestable');
    }
}
