<?php

namespace Core\Financial\Models;

use Core\Base\Models\Base;

class InvoiceItem extends Base
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'invoice_items';

    /**
     * get the invoice.
     */
    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id');
    }

    /**
     * Get the parent itemable model.
     */
    public function itemable()
    {
        return $this->morphTo(__FUNCTION__, 'itemable_type', 'itemable_id');
    }
}
