<?php

namespace Core\Financial\Models;

use Core\Base\Models\Base;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Invoice extends Base
{
    /**
     * Get the parent invoiceable model.
     */
    public function invoiceable()
    {
        return $this->morphTo();
    }

    /**
     * get the items.
     */
    public function items()
    {
        return $this->hasMany(InvoiceItem::class, 'invoice_id');
    }

    /**
     * get the item.
     * when we want to add an invoice as an item,
     * so this is helpful when making a combined invoice for example, so:
     * we have one parent invoice and many children items (invoices).
     */
    public function item()
    {
        return $this->morphOne(InvoiceItem::class, 'itemable');
    }

    /**
     * get the attachments.
     */
    public function attachments()
    {
        return $this->morphMany(\Core\Common\Models\Attachment::class, 'attachmentable');
    }

    /**
     * get the wallet transaction.
     */
    public function walletTransaction()
    {
        return $this->morphOne(WalletTransaction::class, 'transactionable');
    }

    /**
     * Interact with the code.
     *
     * @return \Illuminate\Database\Eloquent\Casts\Attribute
     */
    public function code(): Attribute
    {
        return new Attribute(
            get: fn () => "INV{$this->id}"
        );
    }
}
