<?php

namespace Core\Financial\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Core\Financial\Models\Invoice;
use Core\Auth\Models\User;
use Illuminate\Support\Facades\Notification;
use Core\Financial\Notifications\PendingInvoice;

class HandleNewPendingInvoice implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * invoice
     * 
     * @var Invoice
     */
    protected $invoice;

    /**
     * auth user
     * 
     * @var User
     */
    protected $auth_user;

    /**
     * Create a new job instance.
     *
     * @param  Invoice $invoice
     * @param  User    $auth_user
     * @return void
     */
    public function __construct(Invoice $invoice, User $auth_user)
    {
        $this->invoice   = $invoice;
        $this->auth_user = $auth_user; 
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $admins = \Core\Auth\Models\User::where('userable_type', null)->get();
        Notification::send($admins, new PendingInvoice($this->invoice));
    }
}
