<?php

namespace Core\Financial\Database\Factories;

use Core\Financial\Models\Invoice as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class InvoiceFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'invoiceable_type' => $this->faker->text(100),
            'invoiceable_id' => $this->faker->integer(),
            'status' => $this->faker->text(100),
            'total' => $this->faker->integer(),
            'due_date' => $this->faker->date(),

        ];
    }
}
