<?php

namespace Core\Financial\Database\Factories;

use Core\Financial\Models\Account as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class AccountFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'user_id' => '',
            'bank' => $this->faker->text(100),
            'bank_address' => '',
            'bank_clearing_code' => $this->faker->text(100),
            'bank_code' => $this->faker->text(100),
            'account_number' => $this->faker->text(100),
            'name' => $this->faker->text(100),
            'address' => '',
            'currency' => $this->faker->text(100),

        ];
    }
}
