<?php

namespace Core\Contract\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Provider\Resources\ProviderResource;
use Core\Shipper\Resources\ShipperResource;

class ContractResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'                => $this->id,
            'contractable_type' => $this->contractable_type,
            'contractable_id'   => $this->contractable_id,
            'payment_terms'     => $this->payment_terms,
            $this->mergeWhen($request->route()->getName() == 'api.v1.contracts.show', [
                'provider' => $this->when($this->contractable_type == 'provider', new ProviderResource($this->contractable)),
                'shipper'  => $this->when($this->contractable_type == 'shipper', new ShipperResource($this->contractable)),
                'items'    => ContractItemResource::collection($this->items),
            ])
        ];
    }
}
